@extends('layouts.app')
@section('content')

@if(empty(Session::get('release_form_show')))
<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Add Release</h6>
        </div>

        

    </div>
    @if (count($errors) > 0)
    <div class="alert alert-danger">
        <label>Whoops!</label> There were some problems with your input.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <form class="add-releses-form" method="POST" action="{{ route('release.labels.save') }}" id="frmReleaseStep1212" enctype="multipart/form-data">
        @csrf
        <div class="releases-sec-main">
            <div class="row">
                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                    <div class="form-group main-form">
                        <label class="form-label required" for="language">Label<i class="fa-solid fa-circle-info"></i></label>
                        <select name="label_id" id="admin_label_id" class="form-control">
                            <option value="">Select Label</option>
                            @foreach($lablesUsers as $user)
                            <option value="{{ $user->id }}" @if(old('label_id')==$user->id) selected @endif >{{ ucfirst($user->name) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>


                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3" id="releaseSubLabelsOfLabels">

                    <div class="form-group main-form">
                        <label class="form-label required" for="language">Sub Label
                            <i class="fa-solid fa-circle-info">
                            </i></label>
                        <select name="sublabel_id" id="sublabel_id" class="form-control">
                            <option value="">Select Sub Label</option>
                        </select>
                    </div>

                </div>

                <div class="form-group-button">
                    <button type="submit" class="btn lyricsBtn" id="lyricsSubmit">Next Step</button>
                </div>

            </div>
        </div>
    </form>
</section>

<script>
    $("#admin_label_id").change(function() {
        var label_id = $(this).val();
        // alert(label_id);return false;
        $.ajax({
            url: "{{ route('release.getsublabels.oflables') }}",
            type: "POST",
            data: {
                'label_id': label_id,
                "_token": "{{ csrf_token() }}"
            },
            cache: false,
            success: function(html) {
                if (html) {
                    $("#releaseSubLabelsOfLabels").html(html);
                }
            },
            error: function(textStatus, errorThrown) {
                alert('Something went wrong!');
                return false;
            }
        });
    });
</script>
@endif

@php 
$selectedLabels = null;
if(Session::get('release_labels')){
    $selectedLabelArr = Session::get('release_labels');

    if(!empty($selectedLabelArr['lable']))
    {
        $selectedLabelId = $selectedLabelArr['lable'];
        $user = getUserById($selectedLabelId);
        $selectedLabels = $user->name ?? '';
    }

    if(!empty($selectedLabelArr['sublabel'])){
        $selectedLabelId = $selectedLabelArr['sublabel'];
        $user = getUserById($selectedLabelId);
        $selectedLabels = $user->name ?? '';
    }
}
@endphp 



<section class="right-sidebar" id="sidebarRight" @if(empty(Session::get('release_form_show'))) style="display:none;" @endif>

    @if (count($errors) > 0)
    <div class="alert alert-danger">
        <label>Whoops!</label> There were some problems with your input.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach

        </ul>
    </div>
    @endif

    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Add Release</h6>
        </div>
        <div class="mt-4">

            <a href="{{ route('release.labels.delete') }}" style="float: right;color: #35bdaa;">
                <i class="fa fa-arrow-left" aria-hidden="true"></i>
            </a>
      
            <div class="tab-heading">
                <h6>Release Type</h6>
            </div>

            <ul class="nav nav-tabs rel-type-main" id="myTab" role="tablist">
                <li class="nav-item radio-btn rel-type-box" role="presentation">
                    <input type="radio" name="release_form_type" class="form-check-input active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true" checked>
                    <label class="form-check-label" for="">Single</label>
                </li>
                <li class="nav-item radio-btn rel-type-box" role="presentation">
                    <input type="radio" name="release_form_type" class="form-check-input" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">
                    <label class="form-check-label" for="">Album</label>
                </li>
            </ul>

            <!-- Tab Content -->
            <div class="tab-content mt-3">
                <div class="tab-pane fade s how active show" id="home">
                    <form class="add-releses-form" method="POST" action="{{ route('release.store') }}" id="frmReleaseStep1" enctype="multipart/form-data">

                        @csrf

                        <input type="hidden" class="form-control" name="release_type" value="release">

                        <div class="chose-file-sec">



                            <div class="chose-mainbox artworkpreviewimage" id="release_art_work">
                                <div class="file-icon">
                                    <i class="fa-solid fa-plus"></i>
                                </div>
                                <div class="chose-file-content" id="chose-file-content_artwork">
                                    <h5 class="required">Choose file for Art Work</h5>
                                </div>
                                <input type="file" name="artwork" id="artwork_file" class="form-control" style="display:none;" accept=".jpg, .jpeg, .png" />

                                <p id="single_error-message" style="color:#dc3545"></p>
                            </div>


                            <div class="chose-mainbox appleartworkpreviewimage" id="release_apple_art_work">
                                <div class="file-icon">
                                    <i class="fa-solid fa-plus"></i>
                                </div>
                                <div class="chose-file-content" id="apple_chose-file-content_artwork">
                                    <h5>Choose file for Apple (Motion Art)</h5>
                                </div>
                                <input type="file" name="apple_art" id="apple_art_file" class="form-control" style="display:none;" accept=".jpg, .jpeg, .png" />
                            </div>


                            <div class="chose-mainbox" id="single_release_audio_data">
                                <div class="file-icon">
                                    <i class="fa-solid fa-plus"></i>
                                </div>
                                <div class="chose-file-content">
                                    <h5>Choose Audio Asset</h5>
                                </div>
                                <input type="file" name="single_release_audio" id="single_release_audio" class="form-control" style="display:none;" accept=".mp3" />
                            </div>


                            <div class="chose-mainbox" data-bs-toggle="modal" data-bs-target="#addLyrics">
                                <div class="file-icon">
                                    <i class="fa-solid fa-plus"></i>
                                </div>
                                <div class="chose-file-content">
                                    <h5>Add Lyrics</h5>
                                </div>

                                <!-- <div id="progressBarContainer">
                                    <div id="progressBar">0%</div>
                                </div> -->
                            </div>

                            <div class="modal fade add-lyricist-modal" id="addLyrics" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Add Lyricist</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
                                        </div>

                                        <div class="modal-body">
                                            <div class="Upload-mainbox" id="releaseuploadlyrics">
                                                <div class="file-icon">
                                                    <i class="fa-solid fa-plus"></i>
                                                </div>
                                                <h5>Upload Lyrics</h5>
                                            </div>
                                            <p>Or</p>

                                            <input type="file" name="singleReleaseLyricFile" id="singleReleaseLyricFile" class="form-control" style="display:none;" accept=".txt" />
                                            <div class="form-group">
                                                <label class="form-label" for="uploadLyrics">Paste</label>
                                                <input class="form-control" type="text" id="lyric_urls" name="lyric_urls" />
                                            </div>
                                            <div class="form-group-button">
                                                <button type="button" class="btn lyricsBtn" id="singleReleaselyricsSubmit">Upload</button>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="releases-sec-main">
                            <!-- <form class="add-releses-form"> -->
                            <div class="row">
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="language">Language<i class="fa-solid fa-circle-info"></i></label>

                                            <select name="lang" id="language" class="form-control" required>
                                                <option value="">Select Language</option>
                                                @foreach(getLangs() as $langCode => $langName)
                                                <option value="{{ $langCode }}" @if($langCode =='en') selected @endif>{{ ucfirst($langName) }}</option>
                                                @endforeach
                                            </select>

                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="Release-Title">Release Title<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" name="title" id="Release-Title" required value="{{ old('title') }}">
                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="primary-artist">Choose Primary Artist<i class="fa-solid fa-circle-info"></i></label>
                                        <div class="artist-sec">

                                            <select name="artists" id="artists" class="form-control" required>
                                                <option value="">Select Artist</option>
                                                @foreach($artists as $artist)
                                                <option value="{{ $artist->id }}" @if(old('artists')==$artist->id) selected @endif>{{ ucfirst($artist->name) }}</option>
                                                @endforeach
                                            </select>


                                            @can(['create-artists'])
                                            <a href="javascript:void(0);" id="addArtistRelease">
                                                <button type="button" class="btn artist-sec-btn"><i class="fa-solid fa-plus"></i>Add Artist</button>
                                            </a>
                                            {{--
                                                {{ route('artists.create') }}
                                            <button type="button" class="btn artist-sec-btn" data-bs-toggle="modal" data-bs-target="#addArtist2"><i class="fa-solid fa-plus"></i>Add Artist</button>

                                            --}}
                                            @endcan


                                        </div>


                                        <!-- Add artist modals -->

                                        {{--<div class="modal fade add-artist-modal" id="addArtist2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">Add Lyricist</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
                                                    </div>
                                                    <div class="chose-file-sec">
                                                        <div class="chose-mainbox">
                                                            <div class="file-icon">
                                                                <i class="fa-solid fa-plus"></i>
                                                            </div>
                                                            <div class="chose-file-content">
                                                                <h5>Choose Audio Assest</h5>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-body add-artist-body">
                                                        <div class="artist-sec-main add-artist-main">
                                                            <!-- <form class="artist-sec-form"> -->
                                                            <div class="row">
                                                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                                                                    <div class="form-group artist-form">
                                                                        <label class="form-label" for="name">Name</label>
                                                                        <input type="text" class="form-control" placeholder="DavidDeo" id="name">
                                                                    </div>
                                                                </div>
                                                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                                                                    <div class="form-group artist-form">
                                                                        <label class="form-label" for="email">Email</label>
                                                                        <input type="email" class="form-control" placeholder="DavidDeo" id="email">
                                                                    </div>
                                                                </div>
                                                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                                                                    <div class="form-group artist-form">
                                                                        <label class="form-label" for="music">Sound Cloud</label>
                                                                        <input type="text" class="form-control" placeholder="Music" id="music">
                                                                    </div>
                                                                </div>
                                                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                                                                    <div class="form-group artist-form">
                                                                        <label class="form-label" for="twitter">Twitter</label>
                                                                        <input type="text" class="form-control" placeholder="Music" id="twitter">
                                                                    </div>
                                                                </div>
                                                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                                                                    <div class="form-group artist-form">
                                                                        <label class="form-label" for="facebook">Facebook</label>
                                                                        <input type="text" class="form-control" placeholder="Music" id="facebook">
                                                                    </div>
                                                                </div>
                                                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                                                                    <div class="form-group artist-form">
                                                                        <label class="form-label" for="instagram">Instagram</label>
                                                                        <input type="text" class="form-control" placeholder="Music" id="instagram">
                                                                    </div>
                                                                </div>
                                                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                                                                    <div class="form-group artist-form">
                                                                        <label class="form-label" for="youtube">Youtube OAC</label>
                                                                        <input type="text" class="form-control" placeholder="Actor" id="youtube">
                                                                    </div>
                                                                </div>
                                                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                                                                    <div class="form-group artist-form">
                                                                        <label class="form-label" for="website">Website</label>
                                                                        <input type="text" class="form-control" placeholder="Music" id="website">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <section class="sportify-main">
                                                                <div class="spotify-artist-page">
                                                                    <div class="spotify-heading">
                                                                        <h2>Spotify Artist Page</h2>
                                                                    </div>
                                                                    <div class="spotify-radio">
                                                                        <div class="spotify-radio-head">
                                                                            <h6>is this artist on spotify already?</h6>
                                                                        </div>
                                                                        <div class="artist-spotify-radio">
                                                                            <div class="form-group artist-radio">
                                                                                <input type="radio" name="spotify" id="spotify-radioYes">
                                                                                <label for="spotify-radioYes">Yes, i can provide a link</label>
                                                                            </div>
                                                                            <div class="form-group artist-radio">
                                                                                <input type="radio" name="spotify" id="spotify-radioNo">
                                                                                <label for="spotify-radioNo">No, i need artist page created,(We will request a new artist page be created for you. you must update the page info here once live):</label>
                                                                            </div>
                                                                            <div class="form-group spotify-artist-link">
                                                                                <label for="spotifyArtist">Spotify Artist Link</label>
                                                                                <input type="text" id="spotifyArtist" placeholder="Spotify Link">
                                                                            </div>
                                                                            <div class="form-group spotify-artist-link">
                                                                                <label for="spotifyArtist">Facebook Page Link</label>
                                                                                <input type="text" id="spotifyArtist" placeholder="Facebook Link">
                                                                            </div>
                                                                            <div class="form-group spotify-artist-link">
                                                                                <label for="spotifyArtist">Instagram Page Link</label>
                                                                                <input type="text" id="spotifyArtist" placeholder="Instagram Link">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="artist-cheaks-box">
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" name="ar-cheack" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </section>
                                                            <section class="sportify-main">
                                                                <div class="spotify-artist-page">
                                                                    <div class="spotify-heading">
                                                                        <h2>Apple Artist Page</h2>
                                                                    </div>
                                                                    <div class="spotify-radio">
                                                                        <div class="spotify-radio-head">
                                                                            <h6>is this artist on Apple already?</h6>
                                                                        </div>
                                                                        <div class="artist-spotify-radio">
                                                                            <div class="form-group artist-radio">
                                                                                <input type="radio" name="artist" id="appleYes">
                                                                                <label for="appleYes">Yes, i can provide a link</label>
                                                                            </div>
                                                                            <div class="form-group artist-radio">
                                                                                <input type="radio" name="artist" id="appleNo">
                                                                                <label for="appleNo">No, i need artist page created,(We will request a new artist page be created for you. you must update the page info here once live):</label>
                                                                            </div>
                                                                            <div class="form-group spotify-artist-link">
                                                                                <label for="appleArtist">Apple Artist Link</label>
                                                                                <input type="text" id="appleArtist" placeholder="Apple Link">
                                                                            </div>
                                                                            <div class="form-group spotify-artist-link">
                                                                                <label for="appleArtist">Facebook Artist Link</label>
                                                                                <input type="text" id="appleArtist" placeholder="Facebook Link">
                                                                            </div>
                                                                            <div class="form-group spotify-artist-link">
                                                                                <label for="appleArtist">Instagram Artist Link</label>
                                                                                <input type="text" id="appleArtist" placeholder="Instagram Link">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="apple-artist-cheaks-box">
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" name="ar-cheack" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                    <div class="artist-check-main">
                                                                        <div class="artist-image">
                                                                            <img src="./img/artist.png" alt="Not found">
                                                                        </div>
                                                                        <div class="artist-cheks form-check">
                                                                            <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                                                            <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="artist-btn-main">
                                                                    <button type="submit" class="btn artist-submit-btn"><a href="./addReleases2.html">Submit</a></button>
                                                                </div>
                                                            </section>
                                                            <!-- </form> -->
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>--}}


                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="display-artist">Display Artist<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" name="display_artist" id="display-artist" value="{{ old('display_artist') }}" />
                                    </div>
                                </div>

                                @php 
                                $user = Auth::user();
                                $userRoles = null;
                                if ($user && $user->roles->isNotEmpty()) {
                                    $role = $user->roles->first();
                                    $userRoles = $role->name;
                                }
                                @endphp 

                                @if(!empty($userRoles) && $userRoles!="Super Admin")
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="label">Label<i class="fa-solid fa-circle-info"></i></label>
                                        <select name="label_id" id="label_id" class="form-control">
                                            <option value="">Select Label</option>
                                            @foreach($lablesUsers as $user)
                                            <option value="{{ $user->id }}" @if(old('label_id')==$user->id) selected @endif >{{ ucfirst($user->name) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                @endif


                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="label">Do you have UPC?<i class="fa-solid fa-circle-info"></i></label>
                                        <div class="main-form-radio d-flex justify-content-start gap-3">

                                            <div class="radio-btn">
                                                <input type="radio" value="1" class="form-check-input me-1" name="is_upc" id="is_upc_yes">
                                                <label class="form-check-label" for="yes">Yes</label>
                                            </div>

                                            <div class="radio-btn">
                                                <input type="radio" checked value="0" class="form-check-input me-1" name="is_upc" id="is_upc_no">
                                                <label class="form-check-label" for="no">No</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">

                                        <label class="form-label" id="upc_label_req" for="upc">UPC/EAN
                                            <i class="fa-solid fa-circle-info"></i></label>

                                        <input type="text" class="form-control" placeholder="upc/ean" id="single_upc_number" name="upc_number" readonly disabled />

                                    </div>
                                </div>


                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="isrc">ISRC<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="isrc" class="form-control" placeholder="ISRC" id="isrc" required />
                                    </div>
                                </div>


                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="cline">C-Line<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="c_line" class="form-control" placeholder="C-Line" id="cline" value="{{ $selectedLabels ?? '' }}" required />
                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="cLineYear">C-Line Year<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="c_line_year" class="form-control" placeholder="C-Line Year" id="c_line_year" value="{{ old('c_line_year') ?? date('Y') }}" required />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="pline">P-Line<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="p_line" class="form-control" placeholder="P-Line" id="pline" required value="{{ $selectedLabels ?? '' }}" />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="pLineYear">P-Line Year<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="p_line_year" class="form-control" placeholder="P-Line Year" id="pLineYear" value="{{ old('p_line') ?? date('Y') }}" required />
                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="release_date">Release Date<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="date" class="form-control" placeholder="Release Date" id="release_date" name="release_date" required value="{{ old('release_date') }}" />
                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="main_genre">Main Genre<i class="fa-solid fa-circle-info"></i></label>

                                        <select name="genre_id" id="genre_id" class="form-control" required>
                                            <option value="">Select Genre</option>
                                            @foreach($genres as $genre)
                                            <option value="{{ $genre->id }}" @if(old('genre_id')==$genre->id) selected @endif >{{ ucfirst($genre->title) }}</option>
                                            @endforeach
                                        </select>

                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3" id="subgenredata">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="sub_genre">Sub Genre<i class="fa-solid fa-circle-info"></i></label>
                                        <select name="subgenre_id" id="subgenre_id" class="form-control" required>
                                            <option value="">Select Sub Genre</option>
                                        </select>

                                    </div>
                                </div>


                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    {{--<div class="form-group main-form">
                                        <label class="form-label required" for="Composer">Composer<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" placeholder="Composer" id="Composer" name="composer" required value="{{ old('composer') }}" />
                                    </div>--}}

                                <div class="form-group main-form">
                                    <label class="form-label required" for="lyricist">Composer
                                        <i class="fa-solid fa-circle-info"></i></label>

                                    <div class="sub-sec">
                                        <input type="text" class="form-control" placeholder="First Name" id="Composer" name="composer" required value="{{ old('composer') }}" />

                                        <input type="text" name="composer_lastname" class="form-control" placeholder="Last Name" id="composer_lastname" value="{{ old('composer_lastname') }}" required />
                                    </div>
                                </div>
                                </div>


                                <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="lyricist">Lyricist<i class="fa-solid fa-circle-info"></i></label>
                                        <div class="sub-sec">
                                            <input type="text" name="lyricist_firstname" class="form-control" placeholder="First" id="lyricist_firstname" value="{{ old('lyricist_firstname') }}" required />

                                            <input type="text" name="lyricist_lastname" class="form-control" placeholder="Last" id="lyricist_lastname" value="{{ old('lyricist_lastname') }}" required />
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="catalogue_no">Catalogue Number<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="cat_number" class="form-control" placeholder="Catalogue Number" id="cat_number" value="{{ old('cat_number') }}" />

                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="fe_artist">Featured Artist<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" name="feature_artist" placeholder="Featured Artist" id="feature_artist" value="{{ old('feature_artist') }}" />
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="fe_artist">Is Instrumental?<i class="fa-solid fa-circle-info"></i></label>

                                        <div class="main-form-radio d-flex justify-content-start gap-3">

                                            <div class="radio-btn">
                                                <input type="radio" class="form-check-input me-1" name="is_instrumental" id="is_yes" value="1" @if(old('is_instrumental')==1) selected @endif />
                                                <label class="form-check-label" for="is_yes">Yes</label>
                                            </div>

                                            <div class="radio-btn">
                                                <input type="radio" class="form-check-input me-1" name="is_instrumental" id="is_no" checked value="0" @if(old('is_instrumental')==0) selected @endif />
                                                <label class="form-check-label" for="is_no">No</label>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                

                                <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="actor">Actor<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" placeholder="Actor" id="actor" name="actor" value="{{ old('actor') }}">
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="conductor">Conductor<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" placeholder="Conductor" id="conductor" name="conductor" value="{{ old('conductor') }}">
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="remixer">Remixer<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" placeholder="Remixer" id="remixer" name="remixer" value="{{ old('remixer') }}" />
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="arranger">Arranger<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" placeholder="Arranger" id="arranger" name="arranger" value="{{ old('arranger') }}" />
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">


                                        <label class="form-label sub-label" for="start">CRBT (Start Time)</label>
                                        <input class="form-control" type="time" class="form-control" placeholder="08:30" id="crbt_start_time" name="crbt_start_time" value="{{ old('crbt_start_time') }}" />


                                        {{--<div class="sub-menu">
                                                <label class="form-label sub-label" for="start">CRBT (End Time)</label>
                                                <input class="form-control" type="text" class="form-control" placeholder="09:30" id="crbt_end_time" name="crbt_end_time" value="{{ old('crbt_end_time') }}" />
                                    </div>--}}


                                </div>
                            </div>

                            {{-- 
                                <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="LyricsDuration">Lyrics Duration<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="5:55:5" id="LyricsDuration" name="lyrics_duration" value="{{ old('lyrics_duration') }}" />
                                </div>
                            </div>
                            --}}

                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="copyright_fe">Copyright<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Copyright" id="copyright_fe" name="copyrights" value="{{ old('copyrights') }}" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="orchestra">Orchestra<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Orchestra" id="orchestra" name="orchestra" value="{{ old('orchestra') }}" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="parental_warn">Parental Warning Type<i class="fa-solid fa-circle-info"></i></label>

                                    <!-- <input type="text" class="form-control" placeholder="Explicit" id="parental_warn" > -->

                                    <select name="parental_warning_type" id="parental_warning_type" class="form-control">
                                        <option value="NotExplicit" @if(old('parental_warning_type')=="NotExplicit" ) selected @endif>NotExplicit</option>
                                        <option value="Explicit" @if(old('parental_warning_type')=="Explicit" ) selected @endif>Explicit</option>
                                        <option value="ExplicitContentEdited" @if(old('parental_warning_type')=="ExplicitContentEdited" ) selected @endif>ExplicitContentEdited</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="price_tiers">Price Tiers (For iTunes Only)<i class="fa-solid fa-circle-info"></i></label>
                                    <!-- <input type="text" class="form-control" placeholder="Budget Two" id="price_tiers"> -->

                                    <select name="price_tier" id="price_tier" class="form-control">
                                        <option value="">Select Price Tier</option>

                                        @foreach(release_prices_tires() as $price_key => $price_val)
                                        <option value="{{ $price_key}}" @if(old('price_tier')==$price_key) selected @endif>
                                            {{ $price_val }}
                                        </option>
                                        @endforeach

                                    </select>


                                </div>
                            </div>
                            <div class="col-md-12 col-lg-12 col-xl-12">
                                <div class="form-group main-form">
                                    <label class="form-label" for="release_desc">Release Descriptions</label>

                                    <!-- <textarea class="form-control" id="release_desc" placeholder="Type Here"></textarea> -->

                                    <textarea style="height: 131px;" name="description" id="description" class="form-control">{{ old('description') }}</textarea>

                                </div>
                            </div>
                            <div class="col-md-12 col-lg-12 col-xl-12">
                                <div class="form-group main-form d-flex gap-2">
                                    <button type="submit" class="btn main-next-btn">Submit</button>
                                </div>
                            </div>



                        </div>
                        <!-- </form> -->
                </div>
                </form>
            </div>




            <!-- for album  -->
            <div class="tab-pane fade" id="profile">

            @include('releases.create-album') 
                
             </div>

    </div>
    </div>
    </div>

</section>

<script>
    $(document).ready(function() {
        $('input[name="release_type"]').change(function() {
            var selectedValue = $(this).val();
            alert('Selected release_type: ' + selectedValue);
            return false;
        });
    });
</script>

<script type="text/javascript">
    $(document).ready(function() {
        $("#frmReleaseStep1").validate({
            rules: {
                title: {
                    required: true
                },
                artists: {
                    required: true
                },
                isrc: {
                    required: true
                },
                p_line: {
                    required: true
                },
                c_line: {
                    required: true
                },
                p_line_year: {
                    required: true
                },
                c_line_year: {
                    required: true
                },
                release_date: {
                    required: true
                },
                composer: {
                    required: true
                },
                composer_lastname: {
                    required: true
                },

                genre_id: {
                    required: true
                },

                subgenre_id: {
                    required: true
                },

                lyricist_firstname: {
                    required: true
                },
                lyricist_lastname: {
                    required: true
                },
   
            },
            messages: {
                title: {
                    required: "Title field is required"
                },
                artists: {
                    required: "Artists field is required"
                },
                isrc: {
                    required: "ISRC field is required"
                },

                p_line: {
                    required: "P Line field is required"
                },

                c_line: {
                    required: "C Line field is required"
                },

                p_line_year: {
                    required: "P Line Year field is required"
                },

                c_line_year: {
                    required: "C Line Year field is required"
                },

                release_date: {
                    required: "Release Date field is required"
                },

                composer: {
                    required: "Composer First Name field is required"
                },

                composer_lastname: {
                    required: "Composer Last Name field is required"
                },

                genre_id: {
                    required: "Genre field is required"
                },

                subgenre_id: {
                    required: "Sub Genre field is required"
                },

                lyricist_firstname: {
                    required: "Lyricist First Name field is required"
                },
                lyricist_lastname: {
                    required: "Lyricist Last Name field is required"
                },
            }
        });

        $("#frmReleaseStepAlbum1").validate({
            rules: {
                title: {
                    required: true
                },
                artists: {
                    required: true
                },
                p_line: {
                    required: true
                },
                c_line: {
                    required: true
                },
                p_line_year: {
                    required: true
                },
                c_line_year: {
                    required: true
                },
                release_date: {
                    required: true
                },
                composer: {
                    required: true
                },
                composer_lastname: {
                    required: true
                },

                genre_id: {
                    required: true
                },

                subgenre_id: {
                    required: true
                },

                lyricist_firstname: {
                    required: true
                },
                lyricist_lastname: {
                    required: true
                },


                
            },
            messages: {
                title: {
                    required: "Title field is required"
                },
                artists: {
                    required: "Artists field is required"
                },
                p_line: {
                    required: "P Line field is required"
                },

                c_line: {
                    required: "C Line field is required"
                },

                p_line_year: {
                    required: "P Line Year field is required"
                },

                c_line_year: {
                    required: "C Line Year field is required"
                },

                release_date: {
                    required: "Release Date field is required"
                },
                composer: {
                    required: "Composer First Name field is required"
                },
                composer_lastname: {
                    required: "Composer Last Name field is required"
                },
                genre_id: {
                    required: "Genre field is required"
                },
                subgenre_id: {
                    required: "Sub Genre field is required"
                },
                lyricist_firstname: {
                    required: "Lyricist First Name field is required"
                },
                lyricist_lastname: {
                    required: "Lyricist Last Name field is required"
                },
            }
        });

       

    });

    $("input:radio[name=is_instrumental]").click(function() {
        if ($('input:radio[name=is_instrumental]:checked').val() == "0") {
            $('#lyricistData').show();
        }
        if ($('input:radio[name=is_instrumental]:checked').val() == "1") {
            $('#lyricistData').hide();
        }
    });

    $("input:radio[name=is_upc]").click(function() {
        if ($('input:radio[name=is_upc]:checked').val() == "1") {
            $('#single_upc_number').prop('disabled', false);
            $('#single_upc_number').removeAttr('readonly'); 
            $('#single_upc_number').attr('required', true);
            $('#upc_label_req').addClass('required');
        }
        if ($('input:radio[name=is_upc]:checked').val() == "0") {
            $('#single_upc_number').val('');
            $('#single_upc_number').prop('disabled', true);
            $('#single_upc_number').attr('readonly', true);
            $('#single_upc_number').removeAttr('required', true);
            $('#upc_label_req').removeClass('required');
        }
    });


    // $("#frmReleaseStep1").submit(function() {
    //    alert('dddddd');
    //    return false;
    // });

    $('#frmReleaseStep1').submit(function(e) {
            // Get the file input element
            var fileInput = $('#artwork_file')[0];
            var file = fileInput.files[0];

            // Clear previous error messages
            $('#single_error-message').hide();
            // Check if a file was selected
            if (!file) {
                $('#single_error-message').text('Art Work field is required').show();
                e.preventDefault(); // Prevent form submission
                return false;
            }

            // Validate file type (only WAV files)
            // var fileType = file.type;
            // if (fileType !== 'audio/wav') {
            //     $('#error-message').text('Only WAV files are allowed.').show();
            //     e.preventDefault(); // Prevent form submission
            //     return;
            // }

            // Validate file size (max 10MB)
            // var fileSize = file.size;
            // var maxSize = 10 * 1024 * 1024; // 10MB in bytes
            // if (fileSize > maxSize) {
            //     $('#error-message').text('File size must be less than 10MB.').show();
            //     e.preventDefault(); // Prevent form submission
            //     return;
            // }

        });



    $("#genre_id").change(function() {
        var genre_id = $(this).val();
        $.ajax({
            url: "{{ route('release.subgenre') }}",
            type: "POST",
            data: {
                'genre_id': genre_id,
                "_token": "{{ csrf_token() }}"
            },
            cache: false,
            success: function(html) {
                html = html.replace("<strong>", "<label>");
                html = html.replace("</strong>", "</label>");
                $("#subgenredata").html(html);
            },
            error: function(textStatus, errorThrown) {
                alert('Something went wrong!');
                return false;
            }
        });
    });


    $("#addArtistRelease").click(function() {
        $.ajax({
            url: "{{ route('release.artist.create') }}",
            type: "POST",
            data: {
                'flag': 'release',
                "_token": "{{ csrf_token() }}"
            },
            cache: false,
            success: function(html) {
                window.location.href = "{{ route('artists.create') }}";
            },
            error: function(textStatus, errorThrown) {
                alert('Something went wrong!');
                return false;
            }
        });
    });


    $('#artwork_file').on('change', function (e) {
        var file = e.target.files[0];
        if (file && file.type.startsWith('image/')) {
            var reader = new FileReader();
            reader.onload = function (event) { 
                $('.artworkpreviewimage').css({
                'background-image': 'url("'+event.target.result+'")'
                });
                $('#chose-file-content_artwork').hide();
                $('#single_error-message').hide();
            }
            reader.readAsDataURL(file);
        } else {
            alert('Please select a valid image file');
            return false;
        }       
    });

    $('#apple_art_file').on('change', function (e) {
        var file = e.target.files[0];
        if (file && file.type.startsWith('image/')) {
            var reader = new FileReader();
            reader.onload = function (event) { 
                $('.appleartworkpreviewimage').css({
                'background-image': 'url("'+event.target.result+'")'
                });
                $('#apple_chose-file-content_artwork').hide();
            }
            reader.readAsDataURL(file);
        } else {
            alert('Please select a valid image file');
            return false;
        }       
    });





    let isClickTriggered = false;
    $('#release_art_work').click(function() {
        if (!isClickTriggered) {
            isClickTriggered = true;
            $('#artwork_file').trigger('click');
            isClickTriggered = false;
        }
    });

    let isAppleClickTriggered = false;
    $('#release_apple_art_work').click(function() {
        if (!isAppleClickTriggered) {
            isAppleClickTriggered = true;
            $('#apple_art_file').trigger('click');
            isAppleClickTriggered = false;
        }
    });



    let islyricsClickTriggered = false;
    $(document).on('click', '#releaseuploadlyrics', function() {
        if (!islyricsClickTriggered) {
            islyricsClickTriggered = true;
            $('#singleReleaseLyricFile').trigger('click');
            islyricsClickTriggered = false;
        }
    });


    let is_single_release_audio_data = false;
    $(document).on('click', '#single_release_audio_data', function() {
        if (!is_single_release_audio_data) {
            is_single_release_audio_data = true;
            $('#single_release_audio').trigger('click');
            is_single_release_audio_data = false;
        }
    });

    $(document).on('click', '#singleReleaselyricsSubmit', function() {
        var file = $('#singleReleaseLyricFile')[0].files[0]; // Get the file
        var formData = new FormData(); // Create FormData object
        formData.append('file', file); // Append the file to FormData
        formData.append('_token', "{{ csrf_token() }}"); // Append CSRF token to FormData

        $.ajax({
            url: "{{ route('upload.release.single.lyrics') }}",
            type: 'POST',
            data: formData, // Send FormData
            contentType: false, // Don't set content type because FormData sets it automatically
            processData: false, // Don't process data because it's a file upload
            xhr: function() {
                var xhr = new XMLHttpRequest();
                xhr.upload.addEventListener('progress', function(e) {
                    if (e.lengthComputable) {
                        $("#addLyrics").hide();
                        $('#addLyrics').modal('hide');
                        var percent = (e.loaded / e.total) * 100;
                        $('#progressBar').css('width', percent + '%');
                        $('#progressBar').text(Math.round(percent) + '%');
                    }
                }, false);

                return xhr;
            },
            success: function(response) {
                // alert('File uploaded successfully!');
            },
            error: function(xhr, status, error) {
                alert('An error occurred while uploading the file');
            }
        });
    });
</script>

@php 
    Session::forget('release_form_show');
@endphp 

@endsection